package game;

import java.awt.Graphics;


public class ItemSprite {
	
	private CustomImageDataII[] images;
	private int xPos;
	private int yPos;
	private int itemType;
	private int currentFrame;
	
	public static final int HEART = 0;
	public static final int CHECKPOINT_FLAG = 1;
	public static final int BOSS_CHECKPOINT_FLAG = 2;
	
	private int width, height;
	
	public ItemSprite(int kind, int xLoc, int yLoc, ItemImageManager manager) {
		
		itemType = kind;
		
		
		switch(itemType) {
		default:
		case HEART:
			images = new CustomImageDataII[1];
			images[0] = manager.getHeartImage();
			break;
		case CHECKPOINT_FLAG:
		case BOSS_CHECKPOINT_FLAG:
			images = manager.getCheckpointImages();
			break;
		}
		
		currentFrame = 0;
		
		xPos = xLoc;
		yPos = yLoc;
		
		
		width = Integer.MIN_VALUE;
		height = Integer.MIN_VALUE;
		
		for(CustomImageDataII cid : images) {
			width = Math.max(width, cid.getDesiredWidth());
			height = Math.max(height, cid.getDesiredHeight());
		}
		
		
		
	}

	public IntRect getCollisionRect() {
		return new IntRect(xPos - width/2, yPos - height/2, width, height);
	}

	public int getxPos() {
		return xPos;
	}

	public int getyPos() {
		return yPos;
	}
	
	
	
	public void setxPos(int xPos) {
		this.xPos = xPos;
	}

	public void setyPos(int yPos) {
		this.yPos = yPos;
	}

	public int getItemType() {
		return itemType;
	}
	
	
	public void draw(Graphics g, int playerX, int playerY, int panelWidth, int panelHeight) {
		
		images[currentFrame].drawObject(g, panelWidth/2 + (xPos - playerX) , panelHeight/2 + (yPos - playerY));
		
	}
	
	public void update() {
		
		if(images.length == 1) {
			return;
		}
		

		currentFrame = (currentFrame + 1) % images.length;
		
		
	}
	
}
